import ma
from PyQt5.QtWidgets import *
from PyQt5 import QtCore, QtGui
from PyQt5.QtGui import *
from PyQt5.QtCore import *
import sys


class MyWindow(QWidget):
    def __init__(self):
        super().__init__()

        self.da = []
        self.ar = '서울'
        self.br = ''
        self.cr = '감기'
        self.initUI()
    def initUI(self):
        self.rows = self.da
        headers = ['지역', '발생건수(명)']

        centerGeometry = QDesktopWidget().availableGeometry().center()
        self.resize(600, 400)
        frameGeometry = self.frameGeometry()
        frameGeometry.moveCenter(centerGeometry)

        self.tableWidget = QTableWidget(self)
        self.tableWidget.setRowCount(len(self.rows))
        self.tableWidget.setColumnCount(len(headers))
        self.tableWidget.setEditTriggers(QAbstractItemView.NoEditTriggers)

        self.combo_list = QComboBox(self)
        self.combo_list.addItems(['서울', '부산', '대구', '인천', '광주', '대전', '울산', '경기', '강원', '충북', '전북', '전남', '경북', '경남', '제주'])
        self.combo_list.move(230, 60)
        self.combo_list.currentTextChanged.connect(self.setinf)

        self.combo_list1 = QComboBox(self)
        self.combo_list1.addItems(['감기', '천식', '눈병', '피부병'])
        self.combo_list1.move(370, 60)
        self.combo_list1.currentTextChanged.connect(self.setinf1)

        self.btnRun = QPushButton("실행", self)
        self.btnRun.setGeometry(490, 60, 80, 35)
        self.btnRun.clicked.connect(self.btnRun_clicked)

        self.calendar = QCalendarWidget(self)
        self.calendar.setGeometry(230, 100, 300, 200)

        ld = QDate(2014,1,1)
        ud = QDate(2018, 12, 31)
        self.calendar.setDateRange(ld, ud)

        self.calendar.clicked.connect(self.printDateInfo)









        self.tableWidget.setHorizontalHeaderLabels(headers)




        layout = QVBoxLayout()
        layout.addWidget(self.tableWidget)


        self.setLayout(layout)

    def printDateInfo(self, qDate):
        print('{2}{0}{1}'.format(qDate.month(), qDate.day(), qDate.year()))
        self.date = '{2}/0{0}/0{1}'.format(qDate.month(), qDate.day(), qDate.year())
        if len(self.date) > 8:
            aa = self.date.split('/')
            if len(aa[1]) == 3:
                aa[1] = aa[1][1:3]
            if len(aa[2]) == 3:
                aa[2] = aa[2][1:3]
            self.date = aa[0]+aa[1]+aa[2]
            print(type(self.date))
            self.br = self.date
    def btnRun_clicked(self):
        self.da = ma.main(self.ar,self.br,self.cr)
        self.re = self.da.get()
        print(self.re)
        self.rows = self.re

        self.tableWidget.setRowCount(len(self.rows))
        self.setTableWidgetData()


    def setinf(self):
        self.ar = self.combo_list.currentText()
        print(self.combo_list.currentText())
    def setinf1(self):
        self.cr = self.combo_list1.currentText()
        print(self.combo_list1.currentText())

    def setTableWidgetData(self):
        for b in range(len(self.rows)):
            for c in range(len(self.rows[b])):
                item = QTableWidgetItem(self.rows[b][c])
                if c == 0:
                    item.setTextAlignment(Qt.AlignRight)
                self.tableWidget.setItem(b, c, item)

        self.tableWidget.resizeColumnsToContents()
        self.tableWidget.resizeRowsToContents()


if __name__ == "__main__":
    app = QApplication(sys.argv)
    window = MyWindow()
    window.show()
    sys.exit(app.exec_())